Attribute VB_Name = "TrayIcon"
Option Explicit

'-----------------------------------------------------------------------------------
'  Windows API Calls
'-----------------------------------------------------------------------------------
Private Declare Function CallWindowProc Lib "user32" Alias "CallWindowProcA" (ByVal lpPrevWndFunc As Long, ByVal hwnd As Long, ByVal Msg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
Private Declare Function SetWindowLong Lib "user32" Alias "SetWindowLongA" (ByVal hwnd As Long, ByVal nIndex As Long, ByVal dwNewLong As Long) As Long
Private Declare Function GetWindowLong Lib "user32" Alias "GetWindowLongA" (ByVal hwnd As Long, ByVal nIndex As Long) As Long

Private Type GUID
    Data1 As Long
    Data2 As Integer
    Data3 As Integer
    Data4 As String * 8
End Type

'user defined type required by Shell_NotifyIcon API call
Private Type NOTIFYICONDATA
    cbSize As Long
    hwnd As Long
    uId As Long
    uFlags As Long
    uCallBackMessage As Long
    hIcon As Long
    szTip As String * 128
    dwState As Long
    dwStateMask As Long
    szInfo As String * 256
    uTimeout As Long
    szInfoTitle As String * 64
    dwInfoFlags As Long
    guidItem As GUID
End Type

Public Enum NotifyIcon
    niNone
    niInfo
    niWarning
    niError
End Enum

'constants required by Shell_NotifyIcon API call:
Private Const NIM_ADD& = &H0
Private Const NIM_MODIFY& = &H1
Private Const NIM_DELETE& = &H2
Private Const NIM_SETVERSION& = &H4

Private Const NIF_MESSAGE& = &H1
Private Const NIF_ICON& = &H2
Private Const NIF_TIP& = &H4
Private Const NIF_INFO& = &H10

Private Const NIIF_NONE& = &H0
Private Const NIIF_INFO& = &H1
Private Const NIIF_WARNING& = &H2
Private Const NIIF_ERROR& = &H3
Private Const NIIF_NOSOUND& = &H10

Private Const WM_USER& = &H400
Public Const NIN_SELECT& = WM_USER
Public Const NIN_BALLOONSHOW& = WM_USER + 2
Public Const NIN_BALLOONHIDE& = WM_USER + 3
Public Const NIN_BALLOONTIMEOUT& = WM_USER + 4
Public Const NIN_BALLOONUSERCLICK& = WM_USER + 5

Private Const WM_MOUSEMOVE = &H200
Public Const WM_LBUTTONDOWN = &H201     'Button down
Public Const WM_LBUTTONUP = &H202       'Button up
Public Const WM_LBUTTONDBLCLK = &H203   'Double-click
Public Const WM_RBUTTONDOWN = &H204     'Button down
Public Const WM_RBUTTONUP = &H205       'Button up
Public Const WM_RBUTTONDBLCLK = &H206   'Double-click

Public Declare Function SetForegroundWindow Lib "user32" (ByVal hwnd As Long) As Long
Private Declare Function Shell_NotifyIcon Lib "shell32" Alias "Shell_NotifyIconA" _
    (ByVal dwMessage As Long, pnid As NOTIFYICONDATA) As Long
    
Private Const WM_TRAYEVENT& = &H180
Private Const GWL_WNDPROC = (-4)

Public nid As NOTIFYICONDATA
Private m_hWnd As Long
Private oldProc As Long
Private WPInitialized As Boolean
Private UsingTip As Boolean

Private Const NOTIFYICONDATA_V1_SIZE& = 88

'Private TrayTip As CTooltip

Public Sub InitializeWindowProc(Optional ByVal hwnd As Long = 0)
    If (hwnd <> 0) Then m_hWnd = hwnd
    oldProc = SetWindowLong(m_hWnd, GWL_WNDPROC, AddressOf TrayWindowProc)
    WPInitialized = True
End Sub
 
Public Sub ResetWindowProc()
    WPInitialized = False
    SetWindowLong m_hWnd, GWL_WNDPROC, oldProc
End Sub

Public Function TrayWindowProc(ByVal hwnd As Long, ByVal wMsg As Long, _
    ByVal wParam As Long, ByVal lParam As Long) As Long

    If wMsg = WM_USER Then
        Select Case lParam
            Case NIN_BALLOONSHOW
                'Do nothing.
            Case WM_LBUTTONUP, WM_LBUTTONDBLCLK
                If InTray Then
                    frmMain.WindowState = vbNormal
                    SetForegroundWindow frmMain.hwnd
                    InTray = False
                    frmMain.Show
                End If
            Case WM_RBUTTONUP
                SetForegroundWindow frmMain.hwnd
                frmMain.PopupMenu frmMain.mnuTray
            Case NIN_BALLOONHIDE, NIN_BALLOONTIMEOUT
                notifyType = ntOther
                With nid
                    .szInfo = vbNullChar
                    .szInfoTitle = vbNullChar
                    .dwInfoFlags = NIIF_NONE
                End With
            Case NIN_BALLOONUSERCLICK
                If notifyType = ntOldVersion Then
                    Navigate "http://myriad.bnetweb.com/"
                End If
                notifyType = ntOther
                With nid
                    .szInfo = vbNullChar
                    .szInfoTitle = vbNullChar
                    .dwInfoFlags = NIIF_NONE
                End With
        End Select
    Else
        'CallWindowProc oldProc, hWnd, wMsg, wParam, lParam
    End If
    
End Function

Public Function CreateTrayIcon(ByVal hwnd As Long, ByVal Icon As Long, Optional ByVal ToolTip As String _
    = "", Optional ByVal EnableNotifications As Boolean = False) As Boolean
    m_hWnd = hwnd
    InitializeWindowProc
    With nid
        .uId = 1
        
        If EnableNotifications Then
            .cbSize = Len(nid)
            If Len(ToolTip) Then
                UsingTip = True
                .szTip = ToolTip & vbNullChar
                .uFlags = NIF_ICON Or NIF_TIP Or NIF_MESSAGE Or NIF_INFO
            Else
                UsingTip = False
                .uFlags = NIF_ICON Or NIF_MESSAGE Or NIF_INFO
                .szTip = vbNullChar
            End If
        Else
            .cbSize = NOTIFYICONDATA_V1_SIZE
            If Len(ToolTip) Then
                UsingTip = True
                .szTip = ToolTip & vbNullChar
                .uFlags = NIF_ICON Or NIF_TIP Or NIF_MESSAGE
            Else
                UsingTip = False
                .uFlags = NIF_ICON Or NIF_MESSAGE
                .szTip = vbNullChar
            End If
        End If
        .hIcon = Icon
        .hwnd = hwnd
        
        .uCallBackMessage = WM_USER
        '.uCallBackMessage = WM_MOUSEMOVE
        '.uCallBackMessage = WM_TRAYEVENT
        
        .uId = 0&
    End With
    
    CreateTrayIcon = Shell_NotifyIcon(NIM_ADD, nid)
    If EnableNotifications And CreateTrayIcon Then
        'Set TrayTip = New CTooltip
        'With TrayTip
        '    .Style = TTBalloon
        'End With
        'Shell_NotifyIcon NIM_SETVERSION, nid
    End If
End Function

Public Sub SetToolTip(ByVal NewTip As String)
    nid.szTip = NewTip & vbNullChar
    Shell_NotifyIcon NIM_MODIFY, nid
End Sub

Public Function ShowNotification(Title As String, Text As String, Icon As NotifyIcon) As Boolean
    With nid
        If (Len(Text) + 1) > Len(.szInfoTitle) Then _
            Title = Left$(Title, Len(.szInfoTitle))
        If (Len(Text) + 1) > Len(.szInfo) Then _
            Text = Left$(Text, Len(.szInfo))

        .szInfoTitle = Title & vbNullChar
        .szInfo = Text & vbNullChar
        '.uFlags = NIF_ICON Or NIF_INFO Or NIF_MESSAGE
        .uTimeout = 15000
        Select Case Icon
            Case niNone: .dwInfoFlags = NIIF_NONE
            Case niInfo: .dwInfoFlags = NIIF_INFO
            Case niWarning: .dwInfoFlags = NIIF_WARNING
            Case niError: .dwInfoFlags = NIIF_ERROR
        End Select
    End With
    If (Shell_NotifyIcon(NIM_MODIFY, nid)) Then
        ShowNotification = True
    Else
        ShowNotification = False
    End If
End Function

Public Function DestroyTrayIcon() As Boolean
    ResetWindowProc
    DestroyTrayIcon = (Shell_NotifyIcon(NIM_DELETE, nid))
End Function




